<?php


//format the currency for dashboard sale
function kFormatter($num)
{
    if ($num > 1000) {

        $x = round($num);
        $x_number_format = number_format($x);
        $x_array = explode(',', $x_number_format);
        $x_parts = array('k', 'm', 'b', 't');
        $x_count_parts = count($x_array) - 1;
        $x_display = $x;
        $x_display = $x_array[0] . ((int) $x_array[1][0] !== 0 ? '.' . $x_array[1][0] : '');
        $x_display .= $x_parts[$x_count_parts - 1];

        return $x_display;
    } elseif ($num < 1) {
        return 0;
    }

    return $num;
}

class ControllerExtensionModuleAntonio extends Controller
{
    private $error = array();




    public function index()
    {
        //load language file
        $this->load->language('extension/module/antonio');

        //Set the Document title
        $this->document->setTitle($this->language->get('heading_title'));

        //buttons
        $data['button_save_and_stay'] = $this->language->get('button_save_and_stay');

        //Loads the model admin/model/setting/setting.php so that we can use the methods defined there.
        $this->load->model('setting/setting');

        //This is how we check if it is form submit. When we submit the form then this block of code also run. Then it also validate the modify permission and other validation.

        $this->document->addScript('view/javascript/antonio/ckeditor/ckeditor.js');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

            //This editSetting save the data to  oc_setting database table, see module_ is important else it will not be saved. If you are creating shipping extension then it should be shipping_, for payment extension it should be payment_
            $this->model_setting_setting->editSetting('module_antonio', $this->request->post);


            //This set the success message in the session.
            $this->session->data['success'] = $this->language->get('text_success');
            //This is to redirect to the extensions page.
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
        }
        //show success message
        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];
            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        //This is to check if there are any warnings
        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        //add scripts and styles
        $this->document->addStyle('view/javascript/antonio/patternlock.css');
        $this->document->addScript('view/javascript/antonio/patternlock.js');


        //Following are for breadcrumbs
        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_module'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_antonio'),
            'href' => $this->url->link('extension/module/antonio', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
        );

        //for antonioform URL
        $data['antonioaction'] = $this->url->link('extension/module/antonio/forantonioform', 'user_token=' . $this->session->data['user_token'], true);

        //Form action  URL
        $data['action'] = $this->url->link('extension/module/antonio', 'user_token=' . $this->session->data['user_token'], true);

        //Form cancel URL
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);


        //set & retrieve fields
        // antonio status
        if (isset($this->request->post['module_antonio_status'])) {
            $data['module_antonio_status'] = $this->request->post['module_antonio_status'];
        } else {
            $data['module_antonio_status'] = $this->config->get('module_antonio_status');
        }
        //enable disable lock
        if (isset($this->request->post['module_antonio_lock_status'])) {
            $data['module_antonio_lock_status'] = $this->request->post['module_antonio_lock_status'];
        } else {
            $data['module_antonio_lock_status'] = $this->config->get('module_antonio_lock_status');
        }

        //set RTL OR LTR
        if (isset($this->request->post['module_antonio_align_type'])) {
            $data['module_antonio_align_type'] = $this->request->post['module_antonio_align_type'];
        } else {
            $data['module_antonio_align_type'] = $this->config->get('module_antonio_align_type');
        }


        //check lock type
        if (isset($this->request->post['module_antonio_show_type'])) {
            $data['module_antonio_show_type'] = $this->request->post['module_antonio_show_type'];
        } else {
            $data['module_antonio_show_type'] = $this->config->get('module_antonio_show_type');
        }

        //Set PIN lock value
        if (isset($this->request->post['module_antonio_pin_value'])) {
            $data['module_antonio_pin_value'] = $this->request->post['module_antonio_pin_value'];
        } else {
            $data['module_antonio_pin_value'] = $this->config->get('module_antonio_pin_value');
        }

        //Set pattern lock value
        if (isset($this->request->post['module_antonio_pattern_value'])) {
            $data['module_antonio_pattern_value'] = $this->request->post['module_antonio_pattern_value'];
        } else {
            $data['module_antonio_pattern_value'] = $this->config->get('module_antonio_pattern_value');
        }

        //set footer value
        if (isset($this->request->post['module_antonio_footer_value'])) {
            $data['module_antonio_footer_value'] = $this->request->post['module_antonio_footer_value'];
        } else {
            $data['module_antonio_footer_value'] = $this->config->get('module_antonio_footer_value');
        }

        //set antonio version
        if (isset($this->request->post['module_antonio_version'])) {
            $data['module_antonio_version'] = $this->request->post['module_antonio_version'];
        } else {
            $data['module_antonio_version'] = $this->config->get('module_antonio_version');
        }

        // admin welcome text
        if (isset($this->request->post['module_antonio_anim_text1'])) {
            $data['module_antonio_anim_text1'] = $this->request->post['module_antonio_anim_text1'];
        } else {
            $data['module_antonio_anim_text1'] = $this->config->get('module_antonio_anim_text1');
        }


        //all the antoino form fields
        if (isset($this->request->post['module_antonio_dom'])) {
            $data['module_antonio_dom'] = $this->request->post['module_antonio_dom'];
        } else {
            $data['module_antonio_dom'] = $this->config->get('module_antonio_dom');
        }
        if (isset($this->request->post['module_antonio_extension_id'])) {
            $data['module_antonio_extension_id'] = $this->request->post['module_antonio_extension_id'];
        } else {
            $data['module_antonio_extension_id'] = $this->config->get('module_antonio_extension_id');
        }

        if (isset($this->request->post['module_antonio_email'])) {
            $data['module_antonio_email'] = $this->request->post['module_antonio_email'];
        } else {
            $data['module_antonio_email'] = $this->config->get('module_antonio_email');
        }
        if (isset($this->request->post['module_antonio_order_id'])) {
            $data['module_antonio_order_id'] = $this->request->post['module_antonio_order_id'];
        } else {
            $data['module_antonio_order_id'] = $this->config->get('module_antonio_order_id');
        }



        //send user token as well
        $data['user_token'] = $this->session->data['user_token'];

        //show header, column and footer
        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/antonio', $data));
    }

    public function forantonioform()
    {
        // $this->load->model('extension/module/antonio');
        // if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
        //     $this->model_extension_module_antonio->editSetting2('module_antonio', $this->request->post);

        //     $this->session->data['success'] = $this->language->get('text_success');

        //     // $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
        // }


        // return json_encode("hello");
    }

    public function checkant()
    {
        $datax['antonio_status'] = $this->config->get('module_antonio_status');
        $datax['antonio_lock_status'] = $this->config->get('module_antonio_lock_status');
        $datax['antonio_lock_type'] = $this->config->get('module_antonio_show_type');
        $datax['antonio_pattern_value'] = $this->config->get('module_antonio_pattern_value');

        $datax['module_antonio_anim_text1'] = $this->config->get('module_antonio_anim_text1');

        if ($this->config->get('module_antonio_status')) {
            if ($this->config->get('module_antonio_lock_status')) {

                return $datax;
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    public function getantonio()
    {
        $datax['antonio_status'] = $this->config->get('module_antonio_status');
        $datax['antonio_lock_status'] = $this->config->get('module_antonio_lock_status');
        $datax['antonio_lock_type'] = $this->config->get('module_antonio_show_type');
        $datax['antonio_pattern_value'] = $this->config->get('module_antonio_pattern_value');

        return $datax;
    }


    protected function validate()
    {
        // do not make any changes, its for admin permission
        if (!$this->user->hasPermission('modify', 'extension/module/antonio')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        //check if pattern lock is enabled
        // if (!$this->request->post['module_antonio_status'] == '1' && $this->request->post['module_antonio_lock_status'] == "0") {
        //     if (!utf8_strlen($this->request->post['module_antonio_pattern_value'])) {
        //         $this->error['module_antonio_pattern_value'] = 'Pattern Value error';
        //     }
        // }
        // if (!$this->request->post['module_antonio_status'] == '1' && $this->request->post['module_antonio_lock_status'] == "1") {
        //     if (!utf8_strlen($this->request->post['module_antonio_pin_value'])) {
        //         $this->error['pin'] = 'Pin Error';
        //     }
        // }

        // if ((utf8_strlen($this->request->post['module_antonio_footer_value']) < 3) || (utf8_strlen($this->request->post['module_antonio_footer_value']) > 64)) {
        //     $this->error['module_antonio_footer_value'] = true;
        // }


        return !$this->error;
    }

    public function dashboardRecent()
    {
        //$this->document->addScript('view/javascript/antonio/jquery.animateNumber.min.js');
        //antonio valid
        $data['globalstat'] = $this->config->get('module_antonio_status');
        if ($data['globalstat'] == '1') {

            $this->load->language('extension/dashboard/recent');

            $data['user_token'] = $this->session->data['user_token'];

            // Last 5 Orders
            $data['orders'] = array();

            $filter_data = array(
                'sort'  => 'o.date_added',
                'order' => 'DESC',
                'start' => 0,
                'limit' => 5
            );

            $this->load->model('sale/order');
            $this->load->model('tool/image');
            $this->load->model('extension/module/antonio');

            $results = $this->model_sale_order->getOrders($filter_data);



            foreach ($results as $result) {

                $resultimg = $this->model_sale_order->getOrderProducts($result['order_id']);
                $items = array();
                foreach ($resultimg as $grp_images) {
                    $items[] = $grp_images;
                }

                //fetch payment method
                $antonio_order_method = $this->model_extension_module_antonio->getOrderPaymentMethod($result['order_id']);

                //create product link with id
                $antonio_product_link = str_replace(['https://', 'http://'], '//', HTTP_CATALOG) . 'index.php?route=product/product&product_id=' . $items[0]['product_id'];

                //print_r(json_encode($items));
                //print_r(json_encode($result));
                //fetch product images according to items

                $ocmod_order_image = $this->model_extension_module_antonio->getOrderProductsImage($items[0]['product_id']);
                if ($ocmod_order_image) {
                    ///
                    $new_image = $this->model_tool_image->resize($ocmod_order_image[0]['image'], 115, 115);
                } else {
                    $new_image = $this->model_tool_image->resize('no_image.png', 115, 115);
                }


                $antonio_product_name = $items[0]['name'];


                //count total products in the order
                $totalproducts = count($items);

                $data['orders'][] = array(
                    'order_id'   => $result['order_id'],
                    'name'       => $antonio_product_name,
                    'p_link'    =>  $antonio_product_link,
                    'image'      => $new_image,
                    'totalproducts' => $totalproducts,
                    'time_added' => date($this->language->get('time_format'), strtotime($result['date_added'])),
                    'customer'   => $result['customer'],
                    'p_method'  =>  $antonio_order_method[0]['payment_method'],
                    'status'     => $result['order_status'],
                    'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                    'full_date_time' => date('d/m/Y H:i:s', strtotime($result['date_added'])),
                    'total'      => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                    'view'       => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'], true),
                );
            }

            return $this->load->view('extension/theme/antonio/antonioRecent', $data);
        }
    }



    public function dashboardSale()
    {
        $data['globalstat'] = $this->config->get('module_antonio_status');
        if ($data['globalstat'] == '1') {
            $this->load->language('extension/dashboard/sale');

            $data['user_token'] = $this->session->data['user_token'];
            $this->load->model('localisation/currency');
            $this->load->model('extension/dashboard/sale');




            $today = $this->model_extension_dashboard_sale->getTotalSales(array('filter_date_added' => date('Y-m-d', strtotime('-1 day'))));

            $yesterday = $this->model_extension_dashboard_sale->getTotalSales(array('filter_date_added' => date('Y-m-d', strtotime('-2 day'))));

            $difference = $today - $yesterday;

            if ($difference && (int)$today) {
                $data['percentage'] = round(($difference / $today) * 100);
            } else {
                $data['percentage'] = 0;
            }

            $sale_total = $this->model_extension_dashboard_sale->getTotalSales();

            if ($sale_total > 1000000000000) {
                $data['total'] = round($sale_total / 1000000000000, 1) . 'T';
            } elseif ($sale_total > 1000000000) {
                $data['total'] = round($sale_total / 1000000000, 1) . 'B';
            } elseif ($sale_total > 1000000) {
                $data['total'] = round($sale_total / 1000000, 1) . 'M';
            } elseif ($sale_total > 1000) {
                $data['total'] = round($sale_total / 1000, 1) . 'K';
            } else {
                $data['total'] = round($sale_total);
            }



            //fix for price
            $sym = $this->currency->format('', $this->config->get('config_currency'));
            $newym = preg_replace("/[0-9\.]/", '', $sym);

            //$currency = $this->currency->format($data['total'], $this->config->get('config_currency'));
            //$rcurrency = preg_replace("/\.?0*$/", '', $currency);
            //$data['antonio_currency'] =  $rcurrency;
            $data['antonio_currency'] =    $newym . kFormatter(round($sale_total,1));


            $data['sale'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'], true);

            return $this->load->view('extension/theme/antonio/antonioSale_info', $data);
        } 
    }

    public function dashboardActivity()
    {
        $data['globalstat'] = $this->config->get('module_antonio_status');

        if ($data['globalstat'] == '1') {
            $this->load->language('extension/dashboard/activity');

            $this->load->language('extension/module/antonio_Activity');
            $this->load->model('extension/module/antonio');

            $data['user_token'] = $this->session->data['user_token'];

            $data['activities'] = array();

            $this->load->model('extension/dashboard/activity');

            $results = $this->model_extension_module_antonio->AntoniogetActivities();

            $data['antonio_fulldatax']  = json_encode($results, true);


            foreach ($results as $result) {


                $comment = vsprintf($this->language->get('text_activity_' . $result['key']), json_decode($result['data'], true));
                $antonio_customerid = json_decode($result['data'], true);


                $find = array(
                    'customer_id=',
                    'order_id=',
                    'return_id='
                );

                $replace = array(
                    $this->url->link('customer/customer/edit', 'user_token=' . $this->session->data['user_token'] . '&customer_id=', true),
                    $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=', true),
                    $this->url->link('sale/return/edit', 'user_token=' . $this->session->data['user_token'] . '&return_id=', true)
                );

                $data['activities'][] = array(
                    'antonio_fulldata'  => $result['data'],
                    'keyx'       => $antonio_customerid['customer_id'],
                    'comment'    => str_replace($find, $replace, $comment),
                    'date_added' => date($this->language->get('datetime_format'), strtotime($result['date_added'])),
                    'date_moment' => date($this->language->get('antonio_ampm_nos_date_format'), strtotime($result['date_added']))
                );
            }


            return $this->load->view('extension/theme/antonio/actonioActivity_info', $data);
        }
    }


    //for ajax edit antonio
    public function antonioEditField()
    {

        $json = array();
        $json['error'] = false;
        $this->load->model('catalog/product');
        $this->load->model('extension/module/antonio');
        $this->load->model('tool/image');
        $this->language->load('catalog/product');

        if (isset($this->request->get['product_id']) && isset($this->request->get['field']) && isset($this->request->get['value'])) {
            $product_id = $this->request->get['product_id'];
            $field = $this->request->get['field'];
            $value = $this->request->get['value'];
            $product_special_id = $this->request->get['special_id'];

            $newvalue = html_entity_decode($this->model_extension_module_antonio->antonioEditField($field, $value, $product_id, $product_special_id), ENT_QUOTES, 'UTF-8');

            if ($field == 'status') {
                $json['value'] = ($newvalue) ? $this->language->get('text_enabled') : $this->language->get('text_disabled');
            } elseif ($field == 'image') {
                $json['value'] = ($newvalue) ? $this->model_tool_image->resize($newvalue, 40, 40) : $this->model_tool_image->resize('no_image.png', 40, 40);
            } else {
                $json['value'] = $newvalue;
            }
        } else {
            $json['error'] = '';
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    //for antonio product_list filters
    public function antonioCatFiltersAKAgetlist()
    {

        //load antnio exports
        $this->document->addScript('view/javascript/antonio/antonio_export/xlsx.core.min.js');
        $this->document->addScript('view/javascript/antonio/antonio_export/FileSaver.min.js');
        $this->document->addScript('view/javascript/antonio/antonio_export/tableexport.min.js');

        // Categories
        $this->load->language('catalog/product');
        //$this->load->language('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('catalog/category');



        //$data['cat_name_en'] = $this->language->get('column_name');

        //new getlist() of catalog products

        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }

        if (isset($this->request->get['filter_category'])) {
            $filter_category = $this->request->get['filter_category'];
        } else {
            $filter_category = '';
        }

        if (isset($this->request->get['filter_model'])) {
            $filter_model = $this->request->get['filter_model'];
        } else {
            $filter_model = '';
        }

        if (isset($this->request->get['filter_price'])) {
            $filter_price = $this->request->get['filter_price'];
        } else {
            $filter_price = '';
        }

        if (isset($this->request->get['filter_quantity'])) {
            $filter_quantity = $this->request->get['filter_quantity'];
        } else {
            $filter_quantity = '';
        }

        if (isset($this->request->get['filter_status'])) {
            $filter_status = $this->request->get['filter_status'];
        } else {
            $filter_status = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'pd.name';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'ASC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';
        //for cat filter
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }


        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_price'])) {
            $url .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['add'] = $this->url->link('catalog/product/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['copy'] = $this->url->link('catalog/product/copy', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = $this->url->link('catalog/product/delete', 'user_token=' . $this->session->data['user_token'] . $url, true);

        //add currency in data
        $data['antonio_currency'] = $this->currency->format('', $this->config->get('config_currency'));

        $data['products'] = array();

        $filter_data = array(
            'filter_name'      => $filter_name,
            'filter_category'	  => $filter_category,
            'filter_model'      => $filter_model,
            'filter_price'      => $filter_price,
            'filter_quantity' => $filter_quantity,
            'filter_status'   => $filter_status,
            'sort'            => $sort,
            'order'           => $order,
            'start'           => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'           => $this->config->get('config_limit_admin')
        );

        $this->load->model('tool/image');

        $product_total = $this->model_catalog_product->getTotalProducts($filter_data);

        $results = $this->model_catalog_product->getProducts($filter_data);



        foreach ($results as $result) {

            if (is_file(DIR_IMAGE . $result['image'])) {
                $image = $this->model_tool_image->resize($result['image'], 150, 150);
            } else {
                $image = $this->model_tool_image->resize('no_image.png', 150, 150);
            }


            $special = false;

            $product_specials = $this->model_catalog_product->getProductSpecials($result['product_id']);

            foreach ($product_specials  as $product_special) {
                if (($product_special['date_start'] == '0000-00-00' || strtotime($product_special['date_start']) < time()) && ($product_special['date_end'] == '0000-00-00' || strtotime($product_special['date_end']) > time())) {
                    $special = $this->currency->format($product_special['price'], $this->config->get('config_currency'));
                    $special_id = $product_special['product_special_id'];
                    break;
                }
            }

            $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);

            $data['products'][] = array(
                'full_image' => $result['image'],
                'product_special_id' => (isset($special_id)) ? $special_id : 0,
                'product_id' => $result['product_id'],
                'image'      => $image,
                'name'       => $result['name'],
                'model'      => $result['model'],
                'price'      => $this->currency->format($result['price'], $this->config->get('config_currency')),
                'special'    => $special,
                'quantity'   => $result['quantity'],
                'status'     => $result['status'] ? $this->language->get('text_enabled') : $this->language->get('text_disabled'),
                'edit'       => $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $result['product_id'] . $url, true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';
        if (isset($this->request->get['filter_category'])) {
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }
        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_price'])) {
            $url .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_name'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=pd.name' . $url, true);
        $data['sort_model'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.model' . $url, true);
        $data['sort_price'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.price' . $url, true);
        $data['sort_quantity'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.quantity' . $url, true);
        $data['sort_status'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.status' . $url, true);
        $data['sort_order'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . '&sort=p.sort_order' . $url, true);

        $url = '';
        if (isset($this->request->get['filter_category'])) {
            // 2.9 for cat filter to fetch category name
            $this->load->model('catalog/category');
            $data['category_info'] = $this->model_catalog_category->getCategory($filter_category)['name'];
            $url .= '&filter_category=' . $this->request->get['filter_category'];
        }
        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_price'])) {
            $url .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }


        $pagination = new Pagination();
        $pagination->total = $product_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($product_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($product_total - $this->config->get('config_limit_admin'))) ? $product_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $product_total, ceil($product_total / $this->config->get('config_limit_admin')));

        $data['filter_name'] = $filter_name;
        //for cat filter
        $data['filter_category'] = $filter_category;
        $data['filter_model'] = $filter_model;
        $data['filter_price'] = $filter_price;
        $data['filter_quantity'] = $filter_quantity;
        $data['filter_status'] = $filter_status;

        


        $data['sort'] = $sort;
        $data['order'] = $order;

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $data['globalstat'] = $this->config->get('module_antonio_status');
        //for rest antonio details
        $data['module_antonio_order_id'] = $this->config->get('module_antonio_order_id');
        $data['module_antonio_email'] = $this->config->get('module_antonio_email');
        $data['module_antonio_extension_id'] = $this->config->get('module_antonio_extension_id');

        $data['module_antonio_align_type'] = $this->config->get('module_antonio_align_type');
        if ($data['globalstat'] == '1') {


            $this->response->setOutput($this->load->view('extension/theme/antonio/antonioProduct_list', $data));
        }
    }


    public function AntonioGetForm()
    {
        $data['text_form'] = !isset($this->request->get['product_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');
        $data['globalstat'] = $this->config->get('module_antonio_status');

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['name'])) {
            $data['error_name'] = $this->error['name'];
        } else {
            $data['error_name'] = array();
        }

        if (isset($this->error['meta_title'])) {
            $data['error_meta_title'] = $this->error['meta_title'];
        } else {
            $data['error_meta_title'] = array();
        }

        if (isset($this->error['model'])) {
            $data['error_model'] = $this->error['model'];
        } else {
            $data['error_model'] = '';
        }

        if (isset($this->error['keyword'])) {
            $data['error_keyword'] = $this->error['keyword'];
        } else {
            $data['error_keyword'] = '';
        }

        $url = '';

        if (isset($this->request->get['filter_name'])) {
            $url .= '&filter_name=' . urlencode(html_entity_decode($this->request->get['filter_name'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_model'])) {
            $url .= '&filter_model=' . urlencode(html_entity_decode($this->request->get['filter_model'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_price'])) {
            $url .= '&filter_price=' . $this->request->get['filter_price'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['filter_status'])) {
            $url .= '&filter_status=' . $this->request->get['filter_status'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        if (!isset($this->request->get['product_id'])) {
            $data['action'] = $this->url->link('catalog/product/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        } else {
            $data['action'] = $this->url->link('catalog/product/edit', 'user_token=' . $this->session->data['user_token'] . '&product_id=' . $this->request->get['product_id'] . $url, true);
        }

        $data['cancel'] = $this->url->link('catalog/product', 'user_token=' . $this->session->data['user_token'] . $url, true);

        if (isset($this->request->get['product_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
            $product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
        }

        $data['user_token'] = $this->session->data['user_token'];

        $this->load->model('localisation/language');

        $data['languages'] = $this->model_localisation_language->getLanguages();

        if (isset($this->request->post['product_description'])) {
            $data['product_description'] = $this->request->post['product_description'];
        } elseif (isset($this->request->get['product_id'])) {
            $data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);
        } else {
            $data['product_description'] = array();
        }

        if (isset($this->request->post['model'])) {
            $data['model'] = $this->request->post['model'];
        } elseif (!empty($product_info)) {
            $data['model'] = $product_info['model'];
        } else {
            $data['model'] = '';
        }

        if (isset($this->request->post['sku'])) {
            $data['sku'] = $this->request->post['sku'];
        } elseif (!empty($product_info)) {
            $data['sku'] = $product_info['sku'];
        } else {
            $data['sku'] = '';
        }

        if (isset($this->request->post['upc'])) {
            $data['upc'] = $this->request->post['upc'];
        } elseif (!empty($product_info)) {
            $data['upc'] = $product_info['upc'];
        } else {
            $data['upc'] = '';
        }

        if (isset($this->request->post['ean'])) {
            $data['ean'] = $this->request->post['ean'];
        } elseif (!empty($product_info)) {
            $data['ean'] = $product_info['ean'];
        } else {
            $data['ean'] = '';
        }

        if (isset($this->request->post['jan'])) {
            $data['jan'] = $this->request->post['jan'];
        } elseif (!empty($product_info)) {
            $data['jan'] = $product_info['jan'];
        } else {
            $data['jan'] = '';
        }

        if (isset($this->request->post['isbn'])) {
            $data['isbn'] = $this->request->post['isbn'];
        } elseif (!empty($product_info)) {
            $data['isbn'] = $product_info['isbn'];
        } else {
            $data['isbn'] = '';
        }

        if (isset($this->request->post['mpn'])) {
            $data['mpn'] = $this->request->post['mpn'];
        } elseif (!empty($product_info)) {
            $data['mpn'] = $product_info['mpn'];
        } else {
            $data['mpn'] = '';
        }

        if (isset($this->request->post['location'])) {
            $data['location'] = $this->request->post['location'];
        } elseif (!empty($product_info)) {
            $data['location'] = $product_info['location'];
        } else {
            $data['location'] = '';
        }

        $this->load->model('setting/store');

        $data['stores'] = array();

        $data['stores'][] = array(
            'store_id' => 0,
            'name'     => $this->language->get('text_default')
        );

        $stores = $this->model_setting_store->getStores();

        foreach ($stores as $store) {
            $data['stores'][] = array(
                'store_id' => $store['store_id'],
                'name'     => $store['name']
            );
        }

        if (isset($this->request->post['product_store'])) {
            $data['product_store'] = $this->request->post['product_store'];
        } elseif (isset($this->request->get['product_id'])) {
            $data['product_store'] = $this->model_catalog_product->getProductStores($this->request->get['product_id']);
        } else {
            $data['product_store'] = array(0);
        }

        if (isset($this->request->post['shipping'])) {
            $data['shipping'] = $this->request->post['shipping'];
        } elseif (!empty($product_info)) {
            $data['shipping'] = $product_info['shipping'];
        } else {
            $data['shipping'] = 1;
        }

        if (isset($this->request->post['price'])) {
            $data['price'] = $this->request->post['price'];
        } elseif (!empty($product_info)) {
            $data['price'] = $product_info['price'];
        } else {
            $data['price'] = '';
        }

        $this->load->model('catalog/recurring');

        $data['recurrings'] = $this->model_catalog_recurring->getRecurrings();

        if (isset($this->request->post['product_recurrings'])) {
            $data['product_recurrings'] = $this->request->post['product_recurrings'];
        } elseif (!empty($product_info)) {
            $data['product_recurrings'] = $this->model_catalog_product->getRecurrings($product_info['product_id']);
        } else {
            $data['product_recurrings'] = array();
        }

        $this->load->model('localisation/tax_class');

        $data['tax_classes'] = $this->model_localisation_tax_class->getTaxClasses();

        if (isset($this->request->post['tax_class_id'])) {
            $data['tax_class_id'] = $this->request->post['tax_class_id'];
        } elseif (!empty($product_info)) {
            $data['tax_class_id'] = $product_info['tax_class_id'];
        } else {
            $data['tax_class_id'] = 0;
        }

        if (isset($this->request->post['date_available'])) {
            $data['date_available'] = $this->request->post['date_available'];
        } elseif (!empty($product_info)) {
            $data['date_available'] = ($product_info['date_available'] != '0000-00-00') ? $product_info['date_available'] : '';
        } else {
            $data['date_available'] = date('Y-m-d');
        }

        if (isset($this->request->post['quantity'])) {
            $data['quantity'] = $this->request->post['quantity'];
        } elseif (!empty($product_info)) {
            $data['quantity'] = $product_info['quantity'];
        } else {
            $data['quantity'] = 1;
        }

        if (isset($this->request->post['minimum'])) {
            $data['minimum'] = $this->request->post['minimum'];
        } elseif (!empty($product_info)) {
            $data['minimum'] = $product_info['minimum'];
        } else {
            $data['minimum'] = 1;
        }

        if (isset($this->request->post['subtract'])) {
            $data['subtract'] = $this->request->post['subtract'];
        } elseif (!empty($product_info)) {
            $data['subtract'] = $product_info['subtract'];
        } else {
            $data['subtract'] = 1;
        }

        if (isset($this->request->post['sort_order'])) {
            $data['sort_order'] = $this->request->post['sort_order'];
        } elseif (!empty($product_info)) {
            $data['sort_order'] = $product_info['sort_order'];
        } else {
            $data['sort_order'] = 1;
        }

        $this->load->model('localisation/stock_status');

        $data['stock_statuses'] = $this->model_localisation_stock_status->getStockStatuses();

        if (isset($this->request->post['stock_status_id'])) {
            $data['stock_status_id'] = $this->request->post['stock_status_id'];
        } elseif (!empty($product_info)) {
            $data['stock_status_id'] = $product_info['stock_status_id'];
        } else {
            $data['stock_status_id'] = 0;
        }

        if (isset($this->request->post['status'])) {
            $data['status'] = $this->request->post['status'];
        } elseif (!empty($product_info)) {
            $data['status'] = $product_info['status'];
        } else {
            $data['status'] = true;
        }

        if (isset($this->request->post['weight'])) {
            $data['weight'] = $this->request->post['weight'];
        } elseif (!empty($product_info)) {
            $data['weight'] = $product_info['weight'];
        } else {
            $data['weight'] = '';
        }

        $this->load->model('localisation/weight_class');

        $data['weight_classes'] = $this->model_localisation_weight_class->getWeightClasses();

        if (isset($this->request->post['weight_class_id'])) {
            $data['weight_class_id'] = $this->request->post['weight_class_id'];
        } elseif (!empty($product_info)) {
            $data['weight_class_id'] = $product_info['weight_class_id'];
        } else {
            $data['weight_class_id'] = $this->config->get('config_weight_class_id');
        }

        if (isset($this->request->post['length'])) {
            $data['length'] = $this->request->post['length'];
        } elseif (!empty($product_info)) {
            $data['length'] = $product_info['length'];
        } else {
            $data['length'] = '';
        }

        if (isset($this->request->post['width'])) {
            $data['width'] = $this->request->post['width'];
        } elseif (!empty($product_info)) {
            $data['width'] = $product_info['width'];
        } else {
            $data['width'] = '';
        }

        if (isset($this->request->post['height'])) {
            $data['height'] = $this->request->post['height'];
        } elseif (!empty($product_info)) {
            $data['height'] = $product_info['height'];
        } else {
            $data['height'] = '';
        }

        $this->load->model('localisation/length_class');

        $data['length_classes'] = $this->model_localisation_length_class->getLengthClasses();

        if (isset($this->request->post['length_class_id'])) {
            $data['length_class_id'] = $this->request->post['length_class_id'];
        } elseif (!empty($product_info)) {
            $data['length_class_id'] = $product_info['length_class_id'];
        } else {
            $data['length_class_id'] = $this->config->get('config_length_class_id');
        }

        $this->load->model('catalog/manufacturer');

        if (isset($this->request->post['manufacturer_id'])) {
            $data['manufacturer_id'] = $this->request->post['manufacturer_id'];
        } elseif (!empty($product_info)) {
            $data['manufacturer_id'] = $product_info['manufacturer_id'];
        } else {
            $data['manufacturer_id'] = 0;
        }

        if (isset($this->request->post['manufacturer'])) {
            $data['manufacturer'] = $this->request->post['manufacturer'];
        } elseif (!empty($product_info)) {
            $manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product_info['manufacturer_id']);

            if ($manufacturer_info) {
                $data['manufacturer'] = $manufacturer_info['name'];
            } else {
                $data['manufacturer'] = '';
            }
        } else {
            $data['manufacturer'] = '';
        }

        // Categories
        $this->load->model('catalog/category');

        if (isset($this->request->post['product_category'])) {
            $categories = $this->request->post['product_category'];
        } elseif (isset($this->request->get['product_id'])) {
            $categories = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
        } else {
            $categories = array();
        }

        $data['product_categories'] = array();

        foreach ($categories as $category_id) {
            $category_info = $this->model_catalog_category->getCategory($category_id);

            if ($category_info) {
                $data['product_categories'][] = array(
                    'category_id' => $category_info['category_id'],
                    'name'        => ($category_info['path']) ? $category_info['path'] . ' &gt; ' . $category_info['name'] : $category_info['name']
                );
            }
        }

        // Filters
        $this->load->model('catalog/filter');

        if (isset($this->request->post['product_filter'])) {
            $filters = $this->request->post['product_filter'];
        } elseif (isset($this->request->get['product_id'])) {
            $filters = $this->model_catalog_product->getProductFilters($this->request->get['product_id']);
        } else {
            $filters = array();
        }

        $data['product_filters'] = array();

        foreach ($filters as $filter_id) {
            $filter_info = $this->model_catalog_filter->getFilter($filter_id);

            if ($filter_info) {
                $data['product_filters'][] = array(
                    'filter_id' => $filter_info['filter_id'],
                    'name'      => $filter_info['group'] . ' &gt; ' . $filter_info['name']
                );
            }
        }

        // Attributes
        $this->load->model('catalog/attribute');

        if (isset($this->request->post['product_attribute'])) {
            $product_attributes = $this->request->post['product_attribute'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_attributes = $this->model_catalog_product->getProductAttributes($this->request->get['product_id']);
        } else {
            $product_attributes = array();
        }

        $data['product_attributes'] = array();

        foreach ($product_attributes as $product_attribute) {
            $attribute_info = $this->model_catalog_attribute->getAttribute($product_attribute['attribute_id']);

            if ($attribute_info) {
                $data['product_attributes'][] = array(
                    'attribute_id'                  => $product_attribute['attribute_id'],
                    'name'                          => $attribute_info['name'],
                    'product_attribute_description' => $product_attribute['product_attribute_description']
                );
            }
        }

        // Options
        $this->load->model('catalog/option');

        if (isset($this->request->post['product_option'])) {
            $product_options = $this->request->post['product_option'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_options = $this->model_catalog_product->getProductOptions($this->request->get['product_id']);
        } else {
            $product_options = array();
        }

        $data['product_options'] = array();

        foreach ($product_options as $product_option) {
            $product_option_value_data = array();

            if (isset($product_option['product_option_value'])) {
                foreach ($product_option['product_option_value'] as $product_option_value) {
                    $product_option_value_data[] = array(
                        'product_option_value_id' => $product_option_value['product_option_value_id'],
                        'option_value_id'         => $product_option_value['option_value_id'],
                        'quantity'                => $product_option_value['quantity'],
                        'subtract'                => $product_option_value['subtract'],
                        'price'                   => $product_option_value['price'],
                        'price_prefix'            => $product_option_value['price_prefix'],
                        'points'                  => $product_option_value['points'],
                        'points_prefix'           => $product_option_value['points_prefix'],
                        'weight'                  => $product_option_value['weight'],
                        'weight_prefix'           => $product_option_value['weight_prefix']
                    );
                }
            }

            $data['product_options'][] = array(
                'product_option_id'    => $product_option['product_option_id'],
                'product_option_value' => $product_option_value_data,
                'option_id'            => $product_option['option_id'],
                'name'                 => $product_option['name'],
                'type'                 => $product_option['type'],
                'value'                => isset($product_option['value']) ? $product_option['value'] : '',
                'required'             => $product_option['required']
            );
        }

        $data['option_values'] = array();

        foreach ($data['product_options'] as $product_option) {
            if ($product_option['type'] == 'select' || $product_option['type'] == 'radio' || $product_option['type'] == 'checkbox' || $product_option['type'] == 'image') {
                if (!isset($data['option_values'][$product_option['option_id']])) {
                    $data['option_values'][$product_option['option_id']] = $this->model_catalog_option->getOptionValues($product_option['option_id']);
                }
            }
        }

        $this->load->model('customer/customer_group');

        $data['customer_groups'] = $this->model_customer_customer_group->getCustomerGroups();

        if (isset($this->request->post['product_discount'])) {
            $product_discounts = $this->request->post['product_discount'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_discounts = $this->model_catalog_product->getProductDiscounts($this->request->get['product_id']);
        } else {
            $product_discounts = array();
        }

        $data['product_discounts'] = array();

        foreach ($product_discounts as $product_discount) {
            $data['product_discounts'][] = array(
                'customer_group_id' => $product_discount['customer_group_id'],
                'quantity'          => $product_discount['quantity'],
                'priority'          => $product_discount['priority'],
                'price'             => $product_discount['price'],
                'date_start'        => ($product_discount['date_start'] != '0000-00-00') ? $product_discount['date_start'] : '',
                'date_end'          => ($product_discount['date_end'] != '0000-00-00') ? $product_discount['date_end'] : ''
            );
        }

        if (isset($this->request->post['product_special'])) {
            $product_specials = $this->request->post['product_special'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_specials = $this->model_catalog_product->getProductSpecials($this->request->get['product_id']);
        } else {
            $product_specials = array();
        }

        $data['product_specials'] = array();

        foreach ($product_specials as $product_special) {
            $data['product_specials'][] = array(
                'customer_group_id' => $product_special['customer_group_id'],
                'priority'          => $product_special['priority'],
                'price'             => $product_special['price'],
                'date_start'        => ($product_special['date_start'] != '0000-00-00') ? $product_special['date_start'] : '',
                'date_end'          => ($product_special['date_end'] != '0000-00-00') ? $product_special['date_end'] :  ''
            );
        }

        // Image
        if (isset($this->request->post['image'])) {
            $data['image'] = $this->request->post['image'];
        } elseif (!empty($product_info)) {
            $data['image'] = $product_info['image'];
        } else {
            $data['image'] = '';
        }

        $this->load->model('tool/image');

        $this->document->addScript('view/javascript/antonio/touch-dnd.js');


        if (isset($this->request->post['image']) && is_file(DIR_IMAGE . $this->request->post['image'])) {

            $data['thumb'] = $this->model_tool_image->resize($this->request->post['image'], 150, 150);
        } elseif (!empty($product_info) && is_file(DIR_IMAGE . $product_info['image'])) {
            $data['thumb'] = $this->model_tool_image->resize($product_info['image'], 150, 150);
        } else {
            $data['thumb'] = $this->model_tool_image->resize('no_image.png', 150, 150);
        }

        if ($data['thumb']) {
            $xx = str_replace("-150x150", "", basename($data['thumb']));
        } else {
            $xx = 'no_image.png';
        }
        $data['filename'] = $xx;

        $data['placeholder'] = $this->model_tool_image->resize('no_image.png', 150, 150);

        // Images
        if (isset($this->request->post['product_image'])) {
            $product_images = $this->request->post['product_image'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_images = $this->model_catalog_product->getProductImages($this->request->get['product_id']);
        } else {
            $product_images = array();
        }

        $data['product_images'] = array();

        foreach ($product_images as $product_image) {
            if (is_file(DIR_IMAGE . $product_image['image'])) {
                $image = $product_image['image'];
                $thumb = $product_image['image'];
            } else {
                $image = '';
                $thumb = 'no_image.png';
            }

            if ($image) {
                $add_f = str_replace("-150x150", "", basename($image));
            } else {
                $add_f = 'no_image.png';
            }

            $data['product_images'][] = array(
                'add_filename'      => $add_f,
                'image'      => $image,
                'thumb'      => $this->model_tool_image->resize($thumb, 150, 150),
                'sort_order' => $product_image['sort_order']
            );
        }

        // Downloads
        $this->load->model('catalog/download');

        if (isset($this->request->post['product_download'])) {
            $product_downloads = $this->request->post['product_download'];
        } elseif (isset($this->request->get['product_id'])) {
            $product_downloads = $this->model_catalog_product->getProductDownloads($this->request->get['product_id']);
        } else {
            $product_downloads = array();
        }

        $data['product_downloads'] = array();

        foreach ($product_downloads as $download_id) {
            $download_info = $this->model_catalog_download->getDownload($download_id);

            if ($download_info) {
                $data['product_downloads'][] = array(
                    'download_id' => $download_info['download_id'],
                    'name'        => $download_info['name']
                );
            }
        }

        if (isset($this->request->post['product_related'])) {
            $products = $this->request->post['product_related'];
        } elseif (isset($this->request->get['product_id'])) {
            $products = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);
        } else {
            $products = array();
        }

        $data['product_relateds'] = array();

        foreach ($products as $product_id) {
            $related_info = $this->model_catalog_product->getProduct($product_id);

            if ($related_info) {
                $data['product_relateds'][] = array(
                    'product_id' => $related_info['product_id'],
                    'name'       => $related_info['name']
                );
            }
        }

        if (isset($this->request->post['points'])) {
            $data['points'] = $this->request->post['points'];
        } elseif (!empty($product_info)) {
            $data['points'] = $product_info['points'];
        } else {
            $data['points'] = '';
        }

        if (isset($this->request->post['product_reward'])) {
            $data['product_reward'] = $this->request->post['product_reward'];
        } elseif (isset($this->request->get['product_id'])) {
            $data['product_reward'] = $this->model_catalog_product->getProductRewards($this->request->get['product_id']);
        } else {
            $data['product_reward'] = array();
        }

        if (isset($this->request->post['product_seo_url'])) {
            $data['product_seo_url'] = $this->request->post['product_seo_url'];
        } elseif (isset($this->request->get['product_id'])) {
            $data['product_seo_url'] = $this->model_catalog_product->getProductSeoUrls($this->request->get['product_id']);
        } else {
            $data['product_seo_url'] = array();
        }

        if (isset($this->request->post['product_layout'])) {
            $data['product_layout'] = $this->request->post['product_layout'];
        } elseif (isset($this->request->get['product_id'])) {
            $data['product_layout'] = $this->model_catalog_product->getProductLayouts($this->request->get['product_id']);
        } else {
            $data['product_layout'] = array();
        }

        $this->load->model('design/layout');

        $data['layouts'] = $this->model_design_layout->getLayouts();

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        //for antonio data
        $data['globalstat'] = $this->config->get('module_antonio_status');
        $data['module_antonio_order_id'] = $this->config->get('module_antonio_order_id');
        $data['module_antonio_email'] = $this->config->get('module_antonio_email');
        $data['module_antonio_extension_id'] = $this->config->get('module_antonio_extension_id');
        $data['module_antonio_align_type'] = $this->config->get('module_antonio_align_type');

$this->load->model('catalog/seo_package');
      
$data['seo_multistore_active'] = $this->config->get('mlseo_multistore');

if ($this->config->get('mlseo_multistore')) {
  if (isset($this->request->post['seo_product_description'])) {
    $data['seo_product_description'] = $this->request->post['seo_product_description'];
  } elseif (isset($this->request->get['product_id'])) {
    $data['seo_product_description'] = $this->model_catalog_seo_package->getSeoDescriptions('product', $this->request->get['product_id']);
  } else {
    $data['seo_product_description'] = array();
  }
}
      
if (isset($this->request->post['meta_robots'])) {
  $data['meta_robots'] = $this->request->post['meta_robots'];
} elseif (!empty($product_info['meta_robots'])) {
  $data['meta_robots'] = $product_info['meta_robots'];
} else {
  $data['meta_robots'] = '';
}
      
if (isset($this->request->post['seo_canonical'])) {
  $data['seo_canonical'] = $this->request->post['seo_canonical'];
} elseif (!empty($product_info['seo_canonical'])) {
  $data['seo_canonical'] = $product_info['seo_canonical'];
} else {
  $data['seo_canonical'] = '';
}
      
unset($this->session->data['gkd_seorand']);
      
$this->load->model('tool/gkd_lib');
$data['item_type'] = 'product';
$data['seo_package_tab'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'seo_tab');
$data['seo_package_snippet_robots'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'snippet_robots');
$data['seo_package_snippet_seo_canonical'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'seo_canonical');
$data['seo_package_snippet_metas'] = $this->model_tool_gkd_lib->fetch('module/complete_seo_inc', $data, 'snippet_metas', 'all');

        $this->response->setOutput($this->load->view('catalog/product_form', $data));
    }

    //for order/list
    public function AntoniogetList()
    {
        if (isset($this->request->get['filter_order_id'])) {
            $filter_order_id = $this->request->get['filter_order_id'];
        } else {
            $filter_order_id = '';
        }

        if (isset($this->request->get['filter_customer'])) {
            $filter_customer = $this->request->get['filter_customer'];
        } else {
            $filter_customer = '';
        }

        if (isset($this->request->get['filter_order_status'])) {
            $filter_order_status = $this->request->get['filter_order_status'];
        } else {
            $filter_order_status = '';
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_total'])) {
            $filter_total = $this->request->get['filter_total'];
        } else {
            $filter_total = '';
        }

        if (isset($this->request->get['filter_date_added'])) {
            $filter_date_added = $this->request->get['filter_date_added'];
        } else {
            $filter_date_added = '';
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $filter_date_modified = $this->request->get['filter_date_modified'];
        } else {
            $filter_date_modified = '';
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'o.order_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url, true)
        );

        $data['invoice'] = $this->url->link('sale/order/invoice', 'user_token=' . $this->session->data['user_token'], true);
        $data['shipping'] = $this->url->link('sale/order/shipping', 'user_token=' . $this->session->data['user_token'], true);
        $data['add'] = $this->url->link('sale/order/add', 'user_token=' . $this->session->data['user_token'] . $url, true);
        $data['delete'] = str_replace('&amp;', '&', $this->url->link('sale/order/delete', 'user_token=' . $this->session->data['user_token'] . $url, true));

        $data['orders'] = array();

        $filter_data = array(
            'filter_order_id'        => $filter_order_id,
            'filter_customer'         => $filter_customer,
            'filter_order_status'    => $filter_order_status,
            'filter_order_status_id' => $filter_order_status_id,
            'filter_total'           => $filter_total,
            'filter_date_added'      => $filter_date_added,
            'filter_date_modified'   => $filter_date_modified,
            'sort'                   => $sort,
            'order'                  => $order,
            'start'                  => ($page - 1) * $this->config->get('config_limit_admin'),
            'limit'                  => $this->config->get('config_limit_admin')
        );

        $order_total = $this->model_sale_order->getTotalOrders($filter_data);

        $results = $this->model_sale_order->getOrders($filter_data);



        $data['user_token'] = $this->session->data['user_token'];

        // Last 5 Orders
        $data['orders'] = array();



        $this->load->model('sale/order');
        $this->load->model('tool/image');
        $this->load->model('extension/module/antonio');

        $results = $this->model_sale_order->getOrders($filter_data);


        foreach ($results as $result) {

            $resultimg = $this->model_sale_order->getOrderProducts($result['order_id']);
            $items = array();
            foreach ($resultimg as $grp_images) {
                $items[] = $grp_images;
            }

            //fetch payment method
            $antonio_order_method = $this->model_extension_module_antonio->getOrderPaymentMethod($result['order_id']);

            //create product link with id
            $antonio_product_link = str_replace(['https://', 'http://'], '//', HTTP_CATALOG) . 'index.php?route=product/product&product_id=' . $items[0]['product_id'];

            //print_r(json_encode($items));
            //print_r(json_encode($result));
            //fetch product images according to items

            $ocmod_order_image = $this->model_extension_module_antonio->getOrderProductsImage($items[0]['product_id']);

            if(isset($ocmod_order_image[0]['image'])){
    $new_image = $this->model_tool_image->resize($ocmod_order_image[0]['image'], 115, 115);
}else{
    $new_image = "https://m2.ist/image/no_image-115x115.png";
}

            $antonio_product_name = $items[0]['name'];


            //count total products in the order
            $totalproducts = count($items);

            $data['orders'][] = array(
                'order_id'   => $result['order_id'],
                'name'       => $antonio_product_name,
                'p_link'    =>  $antonio_product_link,
                'image'      => $new_image,
                'totalproducts' => $totalproducts,
                'time_added' => date($this->language->get('time_format'), strtotime($result['date_added'])),
                'date_modified' => date($this->language->get('date_format_short'), strtotime($result['date_modified'])),
                'shipping_code' => $result['shipping_code'],
                'customer'   => $result['customer'],
                'p_method'  =>  $antonio_order_method[0]['payment_method'],
                'status'     => $result['order_status'],
                'order_status'  => $result['order_status'] ? $result['order_status'] : $this->language->get('text_missing'),
                'date_added' => date($this->language->get('date_format_short'), strtotime($result['date_added'])),
                'full_date_time' => date('d/m/Y H:i:s', strtotime($result['date_added'])),
                'total'      => $this->currency->format($result['total'], $result['currency_code'], $result['currency_value']),
                'view'       => $this->url->link('sale/order/info', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'], true),
                'edit'          => $this->url->link('sale/order/edit', 'user_token=' . $this->session->data['user_token'] . '&order_id=' . $result['order_id'] . $url, true)
            );
        }

        $data['user_token'] = $this->session->data['user_token'];

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->session->data['success'])) {
            $data['success'] = $this->session->data['success'];

            unset($this->session->data['success']);
        } else {
            $data['success'] = '';
        }

        if (isset($this->request->post['selected'])) {
            $data['selected'] = (array)$this->request->post['selected'];
        } else {
            $data['selected'] = array();
        }

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if ($order == 'ASC') {
            $url .= '&order=DESC';
        } else {
            $url .= '&order=ASC';
        }

        if (isset($this->request->get['page'])) {
            $url .= '&page=' . $this->request->get['page'];
        }

        $data['sort_order'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.order_id' . $url, true);
        $data['sort_customer'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=customer' . $url, true);
        $data['sort_status'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=order_status' . $url, true);
        $data['sort_total'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.total' . $url, true);
        $data['sort_date_added'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_added' . $url, true);
        $data['sort_date_modified'] = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . '&sort=o.date_modified' . $url, true);

        $url = '';

        if (isset($this->request->get['filter_order_id'])) {
            $url .= '&filter_order_id=' . $this->request->get['filter_order_id'];
        }

        if (isset($this->request->get['filter_customer'])) {
            $url .= '&filter_customer=' . urlencode(html_entity_decode($this->request->get['filter_customer'], ENT_QUOTES, 'UTF-8'));
        }

        if (isset($this->request->get['filter_order_status'])) {
            $url .= '&filter_order_status=' . $this->request->get['filter_order_status'];
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_total'])) {
            $url .= '&filter_total=' . $this->request->get['filter_total'];
        }

        if (isset($this->request->get['filter_date_added'])) {
            $url .= '&filter_date_added=' . $this->request->get['filter_date_added'];
        }

        if (isset($this->request->get['filter_date_modified'])) {
            $url .= '&filter_date_modified=' . $this->request->get['filter_date_modified'];
        }

        if (isset($this->request->get['sort'])) {
            $url .= '&sort=' . $this->request->get['sort'];
        }

        if (isset($this->request->get['order'])) {
            $url .= '&order=' . $this->request->get['order'];
        }

        $pagination = new Pagination();
        $pagination->total = $order_total;
        $pagination->page = $page;
        $pagination->limit = $this->config->get('config_limit_admin');
        $pagination->url = $this->url->link('sale/order', 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', true);

        $data['pagination'] = $pagination->render();

        $data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

        $data['filter_order_id'] = $filter_order_id;
        $data['filter_customer'] = $filter_customer;
        $data['filter_order_status'] = $filter_order_status;
        $data['filter_order_status_id'] = $filter_order_status_id;
        $data['filter_total'] = $filter_total;
        $data['filter_date_added'] = $filter_date_added;
        $data['filter_date_modified'] = $filter_date_modified;

        $data['sort'] = $sort;
        $data['order'] = $order;

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        // API login
        $data['catalog'] = $this->request->server['HTTPS'] ? HTTPS_CATALOG : HTTP_CATALOG;

        // API login
        $this->load->model('user/api');

        $api_info = $this->model_user_api->getApi($this->config->get('config_api_id'));

        if ($api_info && $this->user->hasPermission('modify', 'sale/order')) {
            $session = new Session($this->config->get('session_engine'), $this->registry);

            $session->start();
            // v2.9
            if (VERSION == '3.0.3.7' || VERSION == '3.0.3.8') {
                $this->model_user_api->deleteApiSessionBySessionId($session->getId());
            } else {
                $this->model_user_api->deleteApiSessionBySessionId($session->getId());
            }

            $this->model_user_api->addApiSession($api_info['api_id'], $session->getId(), $this->request->server['REMOTE_ADDR']);

            $session->data['api_id'] = $api_info['api_id'];

            $data['api_token'] = $session->getId();
        } else {
            $data['api_token'] = '';
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/theme/antonio/antonioOrder_list', $data));
    }

    public function AntoniogetOrders()
    {
        $obj = $_POST['phrase'];
        $this->load->model('extension/module/antonio');
        $data['user_token'] = $this->session->data['user_token'];
        $resultorder = $this->model_extension_module_antonio->antoniogetOrders($obj);
        $items = array();
        foreach ($resultorder as $grp_images) {
            $items[] = ['name' => $grp_images['order_id'], 'link' =>  './index.php?route=sale/order/info&user_token=' . $data['user_token'] . '&order_id=' . $grp_images['order_id']];
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($items));
    }
}
