<?php

function getRequestMethod()
{
    return isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : 'GET';
}

function getContentType()
{
    return isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : '';
}

function isJsonRequest()
{
    return stripos(getContentType(), 'application/json') !== false;
}

function readJsonInput()
{
    $content = trim(file_get_contents("php://input"));
    $decoded = json_decode($content, true);
    return is_array($decoded) ? $decoded : false;
}

function sendErrorResponse($httpCode, $message, $asJson = true)
{
    header("HTTP/1.1 {$httpCode}");
    if ($asJson) {
        header('Content-Type: application/json');
        echo json_encode(array("status" => "error", "message" => $message));
    } else {
        echo "<h1>{$httpCode} - {$message}</h1>";
    }
    exit();
}

function enforceAllowedMethods($allowedMethods)
{
    $method = getRequestMethod();
    if (!in_array($method, $allowedMethods)) {
        $asJson = isJsonRequest();
        sendErrorResponse(405, "Method {$method} Not Allowed", $asJson);
    }
}

function handlePutRequest()
{
    if (!isJsonRequest()) {
        sendErrorResponse(415, "Content type must be application/json");
    }

    $inputData = readJsonInput();
    if ($inputData === false) {
        sendErrorResponse(400, "Invalid JSON data");
    }

    $responseData = array(
        "domain" => isset($inputData["domain"]) ? $inputData["domain"] : '',
        "status" => 1,
        "license_user" => isset($inputData["license_user"]) ? $inputData["license_user"] : '',
        "license_key" => isset($inputData["license_key"]) ? $inputData["license_key"] : '',
        "license_type" => "Regular License",
        "purchase_date" => date("Y-m-d\\TH:i:s.u", strtotime("now")),
        "supported_until" => date("Y-m-d\\TH:i:s.u", strtotime("+1 year")),
        "support_active" => true,
    );

    header('Content-Type: application/json');
    echo json_encode(array(
        "status" => "success",
        "data" => $responseData,
    ));
    exit();
}

// === Entry Point ===
enforceAllowedMethods(array('PUT'));
handlePutRequest();