<?php

function getRequestMethod()
{
    return isset($_SERVER['REQUEST_METHOD']) ? $_SERVER['REQUEST_METHOD'] : 'GET';
}

function getContentType()
{
    return isset($_SERVER['CONTENT_TYPE']) ? $_SERVER['CONTENT_TYPE'] : '';
}

function isJsonRequest()
{
    return stripos(getContentType(), 'application/json') !== false;
}

function sendErrorResponse($httpCode, $message, $asJson = true)
{
    header("HTTP/1.1 " . $httpCode);
    if ($asJson) {
        header('Content-Type: application/json');
        echo json_encode(array("status" => "error", "message" => $message));
    } else {
        echo "<h1>{$httpCode} - {$message}</h1>";
    }
    exit();
}

function sendSuccessResponse($data)
{
    header('Content-Type: application/json');
    echo json_encode(array("status" => "success", "data" => $data));
    exit();
}

function enforceAllowedMethods($allowedMethods)
{
    $method = getRequestMethod();
    if (!in_array($method, $allowedMethods)) {
        $asJson = isJsonRequest();
        sendErrorResponse(405, "Method {$method} Not Allowed", $asJson);
    }
}

function handlePostRequest()
{
    if (!isJsonRequest()) {
        sendErrorResponse(415, "Unsupported Media Type");
    }

    $response_data = array(
        array(
            "domain" => isset($_SERVER["HTTP_HOST"]) ? $_SERVER["HTTP_HOST"] : "",
            "status" => 1,
        )
    );

    sendSuccessResponse($response_data);
}

// === Entry Point ===
enforceAllowedMethods(array('POST'));
handlePostRequest();